package kodename.kodeview.launcher.controller;

import java.net.URL;
import java.util.ResourceBundle;

import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import kodename.kodeview.launcher.viewer.DialogWindow;


public class StartupErrorMessageController implements Initializable {



	@FXML
	private ResourceBundle resources;

	@FXML
	private URL location;

	@FXML
	private Button actionButton;

	@FXML
	private BorderPane borderPane;

	@FXML
	private ImageView cautionImageView;

	@FXML
	private Label msgLabel;

	@FXML
	private Label titleLabel;

	private DialogWindow dialogWindow;



	//public enum ErrorGraphicType{ WARNING, STOP, NONE };

	@Override
	public void initialize(URL arg0, ResourceBundle arg1) {
        assert actionButton != null : "fx:id=\"actionButton\" was not injected: check your FXML file 'MessageDialog.fxml'.";
        assert borderPane != null : "fx:id=\"borderPane\" was not injected: check your FXML file 'MessageDialog.fxml'.";
        assert cautionImageView != null : "fx:id=\"cautionImageView\" was not injected: check your FXML file 'MessageDialog.fxml'.";
        assert msgLabel != null : "fx:id=\"msgLabel\" was not injected: check your FXML file 'MessageDialog.fxml'.";
        assert titleLabel != null : "fx:id=\"titleLabel\" was not injected: check your FXML file 'MessageDialog.fxml'.";
	}


	@FXML
	private void hideDialog(ActionEvent event) {
		dialogWindow.hide();
	}


	
	public void showDialog(Stage stage, String title, String message){
		dialogWindow = new DialogWindow(stage, title);
		cautionImageView.setVisible(true);
		titleLabel.setText(title);
		dialogWindow.createDialog(borderPane);
		actionButton.setText("OK");
		msgLabel.setText(message);
		dialogWindow.show();
	}

}

