package kodename.kodeview.launcher.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

import kodename.kodeview.launcher.Constants;


public class MD5 {

	private static final int readBufferSize = 2048;

	public static String getDigest(File file)
			throws NoSuchAlgorithmException, IOException {

		MessageDigest md5;
		FileInputStream is=null;
		byte[] bytes; 
		int numBytes;
		byte[] digest;
		
		md5= MessageDigest.getInstance(Constants.MESSAGE_DIGEST);
		bytes = new byte[readBufferSize];
		try{
			is = new FileInputStream(file);
			md5.reset();
			
			while ((numBytes = is.read(bytes)) != -1) {
				md5.update(bytes, 0, numBytes);
			}
			digest = md5.digest();
		}catch(IOException e){
			e.printStackTrace();
			digest = null;
		}finally{
			if(is != null){
				is.close();
			}
		}

		return (digest == null? null : byteArrayToHexString(digest));
	}

	
	public static byte[] hexStringToByteArray(String s) {
		int len = s.length();
		byte[] data = new byte[len / 2];
		for (int i = 0; i < len; i += 2) {
			data[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4) + Character
					.digit(s.charAt(i + 1), 16));
		}
		return data;
	}

	public static String byteArrayToHexString(byte buf[]) {
		StringBuffer strbuf = new StringBuffer(buf.length * 2);
		int i;

		for (i = 0; i < buf.length; i++) {
			if (((int) buf[i] & 0xff) < 0x10) {
				strbuf.append("0");
			}
			strbuf.append(Long.toString((int) buf[i] & 0xff, 16));
		}

		return strbuf.toString();
	}


}