/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import sun.security.ec.ECKeyFactory;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.jca.JCAUtil;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ECUtil;

abstract class ECDSASignature
extends SignatureSpi {
    private final MessageDigest messageDigest;
    private SecureRandom random;
    private boolean needsReset;
    private ECPrivateKey privateKey;
    private ECPublicKey publicKey;

    ECDSASignature() {
        this.messageDigest = null;
    }

    ECDSASignature(String string) {
        try {
            this.messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.needsReset = false;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = (ECPublicKey)ECKeyFactory.toECKey(publicKey);
        this.privateKey = null;
        this.resetDigest();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.privateKey = (ECPrivateKey)ECKeyFactory.toECKey(privateKey);
        this.publicKey = null;
        this.random = secureRandom;
        this.resetDigest();
    }

    protected void resetDigest() {
        if (this.needsReset) {
            if (this.messageDigest != null) {
                this.messageDigest.reset();
            }
            this.needsReset = false;
        }
    }

    protected byte[] getDigestValue() throws SignatureException {
        this.needsReset = false;
        return this.messageDigest.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.messageDigest.update(by);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.messageDigest.update(byArray, n, n2);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n <= 0) {
            return;
        }
        this.messageDigest.update(byteBuffer);
        this.needsReset = true;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.privateKey.getS().toByteArray();
        ECParameterSpec eCParameterSpec = this.privateKey.getParams();
        byte[] byArray2 = ECUtil.encodeECParameterSpec(null, eCParameterSpec);
        int n = eCParameterSpec.getCurve().getField().getFieldSize();
        byte[] byArray3 = new byte[((n + 7 >> 3) + 1) * 2];
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        this.random.nextBytes(byArray3);
        try {
            return this.encodeSignature(ECDSASignature.signDigest(this.getDigestValue(), byArray, byArray2, byArray3));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException("Could not sign data", generalSecurityException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        ECParameterSpec eCParameterSpec = this.publicKey.getParams();
        byte[] byArray2 = ECUtil.encodeECParameterSpec(null, eCParameterSpec);
        byte[] byArray3 = this.publicKey instanceof ECPublicKeyImpl ? ((ECPublicKeyImpl)this.publicKey).getEncodedPublicValue() : ECUtil.encodePoint(this.publicKey.getW(), eCParameterSpec.getCurve());
        try {
            return ECDSASignature.verifySignedDigest(this.decodeSignature(byArray), this.getDigestValue(), byArray3, byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException("Could not verify signature", generalSecurityException);
        }
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    private byte[] encodeSignature(byte[] byArray) throws SignatureException {
        try {
            int n = byArray.length >> 1;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            BigInteger bigInteger = new BigInteger(1, byArray2);
            System.arraycopy(byArray, n, byArray2, 0, n);
            BigInteger bigInteger2 = new BigInteger(1, byArray2);
            DerOutputStream derOutputStream = new DerOutputStream(byArray.length + 10);
            derOutputStream.putInteger(bigInteger);
            derOutputStream.putInteger(bigInteger2);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            return derValue.toByteArray();
        }
        catch (Exception exception) {
            throw new SignatureException("Could not encode signature", exception);
        }
    }

    private byte[] decodeSignature(byte[] byArray) throws SignatureException {
        try {
            DerInputStream derInputStream = new DerInputStream(byArray, 0, byArray.length, false);
            DerValue[] derValueArray = derInputStream.getSequence(2);
            if (derValueArray.length != 2 || derInputStream.available() != 0) {
                throw new IOException("Invalid encoding for signature");
            }
            BigInteger bigInteger = derValueArray[0].getPositiveBigInteger();
            BigInteger bigInteger2 = derValueArray[1].getPositiveBigInteger();
            byte[] byArray2 = ECDSASignature.trimZeroes(bigInteger.toByteArray());
            byte[] byArray3 = ECDSASignature.trimZeroes(bigInteger2.toByteArray());
            int n = Math.max(byArray2.length, byArray3.length);
            byte[] byArray4 = new byte[n << 1];
            System.arraycopy(byArray2, 0, byArray4, n - byArray2.length, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
            return byArray4;
        }
        catch (Exception exception) {
            throw new SignatureException("Invalid encoding for signature", exception);
        }
    }

    private static byte[] trimZeroes(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length - 1 && byArray[n] == 0; ++n) {
        }
        if (n == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static native byte[] signDigest(byte[] var0, byte[] var1, byte[] var2, byte[] var3) throws GeneralSecurityException;

    private static native boolean verifySignedDigest(byte[] var0, byte[] var1, byte[] var2, byte[] var3) throws GeneralSecurityException;

    public static final class SHA512
    extends ECDSASignature {
        public SHA512() {
            super("SHA-512");
        }
    }

    public static final class SHA384
    extends ECDSASignature {
        public SHA384() {
            super("SHA-384");
        }
    }

    public static final class SHA256
    extends ECDSASignature {
        public SHA256() {
            super("SHA-256");
        }
    }

    public static final class SHA224
    extends ECDSASignature {
        public SHA224() {
            super("SHA-224");
        }
    }

    public static final class SHA1
    extends ECDSASignature {
        public SHA1() {
            super("SHA1");
        }
    }

    public static final class Raw
    extends ECDSASignature {
        private static final int RAW_ECDSA_MAX = 64;
        private final byte[] precomputedDigest = new byte[64];
        private int offset = 0;

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            this.precomputedDigest[this.offset++] = by;
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            System.arraycopy(byArray, n, this.precomputedDigest, this.offset, n2);
            this.offset += n2;
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            int n = byteBuffer.remaining();
            if (n <= 0) {
                return;
            }
            if (this.offset + n >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            byteBuffer.get(this.precomputedDigest, this.offset, n);
            this.offset += n;
        }

        @Override
        protected void resetDigest() {
            this.offset = 0;
        }

        @Override
        protected byte[] getDigestValue() throws SignatureException {
            if (this.offset > 64) {
                throw new SignatureException("Message digest is too long");
            }
            byte[] byArray = new byte[this.offset];
            System.arraycopy(this.precomputedDigest, 0, byArray, 0, this.offset);
            this.offset = 0;
            return byArray;
        }
    }
}

