package kodename.kodeview.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class PropertiesManager {

	public static Properties loadParams(File propertiesFile) {
		Properties props = new Properties();
		InputStream is = null;

		try {	        
			is = new FileInputStream( propertiesFile );
			props.load( is );
		}
		catch ( Exception e ) {
			props = null;
		}finally{
			if(is != null){
				try{
					is.close();	
				}catch(IOException e){
					e.printStackTrace();
				}
			}
		}

		return props;
	}



	public static Properties loadParamsXML(File propertiesFile) {
		Properties props = new Properties();
		InputStream is = null;

		try {
			is = new FileInputStream( propertiesFile );
			props.loadFromXML( is );
		}
		catch ( Exception e ) {
			props = null; 
		}finally{
			if(is != null){
				try{
					is.close();	
				}catch(IOException e){
					e.printStackTrace();
				}
			}
		}
		
		return props;
	}


	public static void saveParamChanges(Properties props, File propertiesFile) {
		OutputStream out = null;
		String header;
		
		header = "===============    DO NOT EDIT THIS PAGE  =========\n"+
				" The contents of this file are System Generated. Editing\n "
				+ "this file could prevent the application from launching\n "
				+ "or from operating normally.\n";
		try {
			out = new FileOutputStream( propertiesFile );
			props.store(out, header);
		}
		catch (Exception e ) {
			e.printStackTrace();
		}finally{
			if(out != null){
				try{
					out.close();	
				}catch(IOException e){
					e.printStackTrace();
				}
			}
		}
	}

	public static void saveParamChangesAsXML(Properties props, File propertiesFile) {
		OutputStream out = null;
		String header;
		
		header = "===============    DO NOT EDIT THIS PAGE  =========\n"+
				" The contents of this file are System Generated. Editing\n "
				+ "this file could prevent the application from launching\n "
				+ "or from operating normally.\n";
		try {
			out = new FileOutputStream( propertiesFile );
			props.storeToXML(out, header);
		}
		catch (Exception e ) {
			e.printStackTrace();
		}finally{
			if(out != null){
				try{
					out.close();	
				}catch(IOException e){
					e.printStackTrace();
				}
			}
		}
	}
}
