package kodename.kodeview.settings;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

/**
 * So the way a ProxySelector works is that for all Connections made,
 * it delegates to a proxySelector(There is a default we're going to
 * override with this class) to know if it needs to use a proxy
 * for the connection.
 * <p>This class was specifically created with the intent to proxy connections
 * going to the allegiance soap service.</p>
 *
 * @author Nate
 */
public class CustomProxySelector extends ProxySelector {

	private static ProxySelector systemDefaultProxySelector;

	static{
		System.setProperty("java.net.useSystemProxies", "true");
		CustomProxySelector.systemDefaultProxySelector = ProxySelector.getDefault();	
	}

	//private static final Logger logger = Logger.getLogger(CustomProxySelector.class.getName());

	private final List<Proxy> proxyList;

	/*
	 * We want to hang onto the default and delegate
	 * everything to it unless it's one of the url's
	 * we need proxied.
	 */

	public CustomProxySelector(){
		proxyList = new ArrayList<Proxy>();
		
	}
	
	
	public void setNoProxy(){
		Proxy proxy;
		System.setProperty("java.net.useSystemProxies", "false");
		proxy = Proxy.NO_PROXY;
		proxyList.clear();
		proxyList.add(proxy);
		ProxySelector.setDefault(this);
	}
	
	public void setDefaultSystemProxy(){
		proxyList.clear();		
		System.setProperty("java.net.useSystemProxies", "true");
		ProxySelector.setDefault(systemDefaultProxySelector);
	}
	
	public void setManualProxy(String httpsHost, int httpsPort, String httpHost, int httpPort) {
		Proxy proxy;
		System.setProperty("java.net.useSystemProxies", "false");
		proxyList.clear();
		proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpsHost, httpsPort));
		proxyList.add(proxy);
		proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpHost, httpPort));
		proxyList.add(proxy);
		ProxySelector.setDefault(this);
		
	}
	
	
	
	@Override
	public List<Proxy> select(URI uri) {		
		//logger.info("Trying to reach URL : " + uri);
		/*
		if (uri == null) {
			throw new IllegalArgumentException("URI can't be null.");
		}
		if (uri.getHost().contains("allegiancetech")) {
			logger.info("We're trying to reach allegiance so we're going to use the extProxy.");
			return proxyList;
		}
		*/
		if(!proxyList.isEmpty()){
			return proxyList;
		}
		return systemDefaultProxySelector.select(uri);
	}

	/*
	 * Method called by the handlers when it failed to connect
	 * to one of the proxies returned by select().
	 */
	@Override
	public void connectFailed(URI uri, SocketAddress sa, IOException ioe){
		//System.out.println("Failed to connect to a proxy when connecting to " + uri.getHost());
		//logger.severe("Failed to connect to a proxy when connecting to " + uri.getHost());
		if (uri == null || sa == null || ioe == null) {
			throw new IllegalArgumentException("Arguments can't be null.");
		}
		ProxySelector.setDefault(null);
	}
	
}