package kodename.kodeview.settings.controller;

import java.io.File;
import java.util.Properties;

import javafx.application.HostServices;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import kodename.kodeview.settings.Constants;
import kodename.kodeview.settings.ProxyConfig;
import kodename.kodeview.settings.ProxyConfig.PROXY_CONFIG;
import kodename.kodeview.settings.SettingsException;
import kodename.kodeview.settings.viewer.FXMLUrls;

public class SettingsController {

	@FXML
	private VBox settingsVBox;

	@FXML
	private RadioButton noProxyRB;

	@FXML
	private ToggleGroup settingTG;

	@FXML
	private RadioButton useSystemProxySettingRB;

	@FXML
	private RadioButton manualProxyConfigRB;

	@FXML
	private VBox manualSettingVB;

	@FXML
	private HBox httpHB;

	@FXML
	private TextField httpProxyHostTextField;

	@FXML
	private TextField httpProxyPortTextField;

	@FXML
	private HBox sslHB;

	@FXML
	private TextField sslProxyHostTextField;

	@FXML
	private TextField sslProxyPortTextField;

	@FXML
	private HBox titleHBox;

	@FXML
	private Label titleLabel;

	@FXML
	private HBox buttonHBox;

	@FXML
	private Button helpButton;

	@FXML
	private Button cancelButton;

	@FXML
	private Button okButton;

	private ObjectProperty<PROXY_CONFIG> currentProxyConfigProperty;
	private ObjectProperty<PROXY_CONFIG> newProxyConfigProperty;
	private HostServices hostServices;
	private ProxyConfig proxyConfig;
	private Stage stage;
	private DialogWindow dialogWindow;
	
	@FXML
	private void cancel(ActionEvent event) {
		dialogWindow.hide();
	}


	@FXML
	private void help(ActionEvent event) {
		hostServices.showDocument(Constants.HELP_URL_SETTINGS);
	}

	@FXML
	private void ok(ActionEvent event) {
		PROXY_CONFIG settings;

		if(noProxyRB.isSelected()){
			settings = PROXY_CONFIG.NO_PROXY;
		}else if(useSystemProxySettingRB.isSelected()){
			settings = PROXY_CONFIG.SYSTEM;
		}else if(manualProxyConfigRB.isSelected()){
			settings = PROXY_CONFIG.MANUAL;

		}else{
			// this should never be reached.
			settings = null;
		}

		try{
			if(settings == PROXY_CONFIG.MANUAL){
				proxyConfig.configProxySettings(
						httpProxyHostTextField.getText(), httpProxyPortTextField.getText(), 
						sslProxyHostTextField.getText(), sslProxyPortTextField.getText());
			}else{
				proxyConfig.configProxySettings(settings);
			}
			dialogWindow.hide();
		}catch(SettingsException e){			
			SettingsErrorMessageController controller;
			controller = (SettingsErrorMessageController)FXMLControllerLoader.loadController(FXMLUrls.SETTINGS_ERROR_MESSAGE);
			
			controller.showDialog(
					stage,
					e.getErrorTitle(),
					e.getErrorMessage());
		}
	}

	@FXML
	private void initialize() {
		assert settingsVBox != null : "fx:id=\"settingsVBox\" was not injected: check your FXML file 'Settings.fxml'.";
		assert noProxyRB != null : "fx:id=\"noProxyRB\" was not injected: check your FXML file 'Settings.fxml'.";
		assert settingTG != null : "fx:id=\"settingTG\" was not injected: check your FXML file 'Settings.fxml'.";
		assert useSystemProxySettingRB != null : "fx:id=\"useSystemProxySettingRB\" was not injected: check your FXML file 'Settings.fxml'.";
		assert manualProxyConfigRB != null : "fx:id=\"manualProxyConfigRB\" was not injected: check your FXML file 'Settings.fxml'.";
		assert manualSettingVB != null : "fx:id=\"manualSettingVB\" was not injected: check your FXML file 'Settings.fxml'.";
		assert httpHB != null : "fx:id=\"httpHB\" was not injected: check your FXML file 'Settings.fxml'.";
		assert httpProxyHostTextField != null : "fx:id=\"httpProxyHostTextField\" was not injected: check your FXML file 'Settings.fxml'.";
		assert httpProxyPortTextField != null : "fx:id=\"httpProxyPortTextField\" was not injected: check your FXML file 'Settings.fxml'.";
		assert sslHB != null : "fx:id=\"sslHB\" was not injected: check your FXML file 'Settings.fxml'.";
		assert sslProxyHostTextField != null : "fx:id=\"sslProxyHostTextField\" was not injected: check your FXML file 'Settings.fxml'.";
		assert sslProxyPortTextField != null : "fx:id=\"sslProxyPortTextField\" was not injected: check your FXML file 'Settings.fxml'.";
		assert titleHBox != null : "fx:id=\"titleHBox\" was not injected: check your FXML file 'Settings.fxml'.";
		assert titleLabel != null : "fx:id=\"titleLabel\" was not injected: check your FXML file 'Settings.fxml'.";
		assert buttonHBox != null : "fx:id=\"buttonHBox\" was not injected: check your FXML file 'Settings.fxml'.";
		assert helpButton != null : "fx:id=\"helpButton\" was not injected: check your FXML file 'Settings.fxml'.";
		assert cancelButton != null : "fx:id=\"cancelButton\" was not injected: check your FXML file 'Settings.fxml'.";
		assert okButton != null : "fx:id=\"okButton\" was not injected: check your FXML file 'Settings.fxml'.";

		manualSettingVB.disableProperty().bind(Bindings.not(manualProxyConfigRB.selectedProperty()));
		currentProxyConfigProperty = new SimpleObjectProperty<>();
		newProxyConfigProperty = new SimpleObjectProperty<>();

		noProxyRB.selectedProperty().addListener(new ChangeListener<Boolean>(){
			@Override
			public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
				newProxyConfigProperty.set(PROXY_CONFIG.NO_PROXY);									
			}

		});

		manualProxyConfigRB.selectedProperty().addListener(new ChangeListener<Boolean>(){
			@Override
			public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
				newProxyConfigProperty.set(PROXY_CONFIG.MANUAL);									
			}
		});

		useSystemProxySettingRB.selectedProperty().addListener(new ChangeListener<Boolean>(){
			@Override
			public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
				newProxyConfigProperty.set(PROXY_CONFIG.SYSTEM);									
			}
		});

		//okButton.disableProperty().bind(Bindings.equal(currentProxyConfigProperty, newProxyConfigProperty));

	}


	private void initProxySettings(){
		Properties proxyProps;
		String proxy_settings_type;
		// load the properties file
		proxyProps = proxyConfig.getProxySettings();
		proxy_settings_type = proxyProps.getProperty("proxy_settings_type");

		switch(proxy_settings_type){
		case "no_proxy":
			noProxyRB.setSelected(true);		
			currentProxyConfigProperty.set(PROXY_CONFIG.NO_PROXY);
			newProxyConfigProperty.set(PROXY_CONFIG.NO_PROXY);
			break;
		case "system":			
			useSystemProxySettingRB.setSelected(true);			
			currentProxyConfigProperty.set(PROXY_CONFIG.SYSTEM);
			newProxyConfigProperty.set(PROXY_CONFIG.SYSTEM);
			break;
		case "manual":
			currentProxyConfigProperty.set(PROXY_CONFIG.MANUAL);
			newProxyConfigProperty.set(PROXY_CONFIG.MANUAL);
			manualProxyConfigRB.setSelected(true);			
			httpProxyHostTextField.setText(proxyProps.getProperty("http_host"));
			httpProxyPortTextField.setText(proxyProps.getProperty("http_port"));			
			sslProxyHostTextField.setText(proxyProps.getProperty("https_host"));
			sslProxyPortTextField.setText(proxyProps.getProperty("https_port"));			
			break;
		default:

		}
	}
		
	
	public void showDialog(Stage stage, HostServices hostServices, File settingsFile){
		dialogWindow = new DialogWindow(stage, "Proxy Settings");
		this.stage = stage;
		
		this.hostServices = hostServices;
		proxyConfig = new ProxyConfig(settingsFile);
		initProxySettings();
		
		titleLabel.setText("Proxy Settings");
		dialogWindow.createDialog(settingsVBox);
		dialogWindow.show();
	}
	
	
	
}



