package kodename.kodeview.launcher.viewer;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import kodename.kodeview.launcher.Constants;

/**
 * Demonstrates a modal confirm box in JavaFX. Dialog is rendered upon a blurred
 * background. Dialog is translucent.
 */
public class DialogWindow {

	private Parent dialogContent;
	private final Stage dialog;
	private final Stage ownerStage;
	private static  double mouseDragOffsetX = 0;	
	private static double mouseDragOffsetY = 0;

	public DialogWindow(final Stage ownerStage, final String title){
		// initialize the confirmation dialog		
		this(ownerStage, title, Modality.APPLICATION_MODAL);
	}


	public DialogWindow(final Stage owner, final String title, Modality modality){
		ownerStage = owner;
		dialog = new Stage(StageStyle.UNDECORATED);
		dialog.setTitle(title);
		dialog.getIcons().add(Constants.ICON_IMAGE_16);
		dialog.getIcons().add(Constants.ICON_IMAGE_32);
		dialog.initModality(modality);
		dialog.initOwner(owner);


	}

	public void createDialog(Parent node){
		// Desired x coordinate for centered dialog
		final DoubleProperty x = new SimpleDoubleProperty();
		final DoubleProperty y = new SimpleDoubleProperty();

		Scene dialogScene;
		dialogContent = node;

		dialogScene = new Scene(node);
		dialog.setScene(dialogScene);
		dialog.sizeToScene();
		dialogContent.setOnMousePressed(new EventHandler<MouseEvent>() {
			@Override
			public void handle(MouseEvent mouseEvent) {
				// record a delta distance for the drag and drop operation.
				mouseDragOffsetX = mouseEvent.getSceneX();
				mouseDragOffsetY = mouseEvent.getSceneY();

			}
		});

		dialogContent.setOnMouseDragged(new EventHandler<MouseEvent>() {
			@Override
			public void handle(MouseEvent mouseEvent) {
				dialog.setX(mouseEvent.getScreenX()-mouseDragOffsetX);
				dialog.setY(mouseEvent.getScreenY()-mouseDragOffsetY);
			}
		});

		x.bind(ownerStage.xProperty().add(ownerStage.widthProperty().subtract(dialog.widthProperty()).divide(2)));
		y.bind(ownerStage.yProperty().add(ownerStage.heightProperty().subtract(dialog.heightProperty()).divide(2)));

		// Update dialog's x coordinate when x defined above changes
		x.addListener(new ChangeListener<Number>() {
			@Override
			public void changed(ObservableValue<? extends Number> obs, Number oldValue, Number newValue) {
				dialog.setX(newValue.doubleValue());
			}
		});

		// Update dialog's y coordinate when y defined above changes
		y.addListener(new ChangeListener<Number>() {
			@Override
			public void changed(ObservableValue<? extends Number> obs, Number oldValue, Number newValue) {
				dialog.setY(newValue.doubleValue());
			}
		});

		// Unbind x and y when dialog has been shown, to allow user to resize without interference
		dialog.setOnShown(new EventHandler<WindowEvent>() {
			@Override
			public void handle(WindowEvent event) {
				x.unbind();
				y.unbind();
			}
		});

		// Rebind x and y when dialog is hidden, so re-showing will properly center it again
		dialog.setOnHidden(new EventHandler<WindowEvent>() {
			@Override
			public void handle(WindowEvent event) {
				x.unbind();
				y.unbind();
				
				x.bind(ownerStage.xProperty().add(ownerStage.widthProperty().subtract(dialog.widthProperty()).divide(2)));
				y.bind(ownerStage.yProperty().add(ownerStage.heightProperty().subtract(dialog.heightProperty()).divide(2)));
			}
		});
	}

	public void show(){

		try{
			switch(dialog.getModality()){
			case WINDOW_MODAL:
				dialog.showAndWait();				
				break;
			case  APPLICATION_MODAL:
				dialog.showAndWait();
				break;
			case NONE:
				dialog.show();
				break;
			default:
				throw new RuntimeException("Unknow Modality");

			}

		}
		catch(IllegalStateException e){
			e.printStackTrace();
		}

	}


	public void hide(){
		dialog.close();
	}


}