package kodename.kodeview.launcher.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public class JarLoader{


	public static List<String> loadJars(File directory) throws Exception{
		List<String> loadedJars;
		
		loadedJars = new ArrayList<>();
		for(File f: directory.listFiles()){
			if(f.isDirectory()){
				loadedJars.addAll(loadJars(f));
			}else if(f.getName().endsWith(".jar")){
				//if(loadLibrary(f.toURI().toURL())){
				if(loadLibrary(f)){
					loadedJars.add(f.getAbsolutePath());	
				}
			}else{
				
			}
		}
		return loadedJars;
	}
	
	
	public static void loadClasses(String pathToJar) throws IOException{
		JarFile jarFile = null;

		try{
			jarFile= new JarFile(pathToJar);
			Enumeration<JarEntry> e = jarFile.entries();

			URL[] urls = { new URL("jar:file:" + pathToJar+"!/") };
			URLClassLoader cl = URLClassLoader.newInstance(urls);

			while (e.hasMoreElements()) {
				JarEntry je = e.nextElement();
				if(je.isDirectory() || !je.getName().endsWith(".class")){
					continue;
				}
				// -6 because of .class
				String className = je.getName().substring(0,je.getName().length()-6);
				className = className.replace('/', '.');
				try{
					cl.loadClass(className);
				}catch(Exception e1){
					e1.printStackTrace();
				}

			}
		}catch(IOException e){
			e.printStackTrace();
		}finally{
			if(jarFile != null){
				jarFile.close();
			}
		}
	}

	public static List<String> getClasseNames(String pathToJar) throws IOException{
		List<String> classes = new ArrayList<>();
		JarInputStream jarFile = null;
		JarEntry jarEntry;

		try {
			jarFile = new JarInputStream(new FileInputStream(pathToJar));
			while ((jarEntry = jarFile.getNextJarEntry())!=null) {
				if (jarEntry.getName().endsWith(".class")) {
					classes.add(jarEntry.getName().replaceAll("/", "\\."));
					
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			if(jarFile != null){
				jarFile.close();
			}
		}
		return classes;
	}

	private static boolean loadLibrary(File file) throws Exception{
		java.net.URLClassLoader loader;
		String jarFileName;
		String loadedJarFileName;
		// using the actual jar filenames
		jarFileName = file.getName();//Paths.get(url.getPath()).getFileName().toString();
		/*We are using reflection here to circumvent encapsulation; addURL is not public*/
		loader = (java.net.URLClassLoader)ClassLoader.getSystemClassLoader();
		/*Do Not load if Jar is already loaded*/
		for (java.net.URL it : java.util.Arrays.asList(loader.getURLs())){
			loadedJarFileName = new File(it.toURI()).getName();
			if (loadedJarFileName.compareTo(jarFileName)==0){
				return false;
			}
		}
		java.lang.reflect.Method method = java.net.URLClassLoader.class.getDeclaredMethod("addURL", new Class[]{java.net.URL.class});
		method.setAccessible(true); /*promote the method to public access*/
		method.invoke(loader, new Object[]{file.toURI().toURL()});
		return true;
	}


	public static Properties getProperties(File kodeviewJar, String propertiesFileName) throws IOException{
		JarFile jarFile;
		JarEntry jarEntry;
		Properties properties = null;
		InputStream input = null;
		try {
			jarFile = new JarFile(kodeviewJar);
			Enumeration<JarEntry> entries = jarFile.entries();
			while((jarEntry= entries.nextElement()) !=null ){
				if(jarEntry.getName().endsWith(propertiesFileName)){
					 input = jarFile.getInputStream(jarEntry);
					 properties = new Properties();
					 properties.load(input);
					 break;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			if(input != null){
				input.close();
			}
		}
		return properties;
	}


}