package kodename.kodeview.launcher.webservice;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;

import javax.net.ssl.HttpsURLConnection;
//import javax.xml.ws.BindingProvider;

//import com.sun.xml.internal.ws.client.BindingProviderProperties;

import kodename.config.stubs.ClientVersionResponseDT;
import kodename.config.stubs.ConfigWS;
import kodename.config.stubs.ConfigWSEPService;
import kodename.config.stubs.OperatingSystem;

public class ConfigService {

	private ConfigWS configWS;
	private URL configWebServiceUrl;
	private static final int CONNECTION_TIMEOUT = 60000;

	public ConfigService(URL url) throws DesktopLauncherException{
		this.configWebServiceUrl = url;
		configWS  = getConfigService();		
	}

	private ConfigWS getConfigService() throws DesktopLauncherException{
		ConfigWSEPService configService;
		ensureServiceAvailability(configWebServiceUrl);
		configService = new ConfigWSEPService(configWebServiceUrl);
		return configService.getConfigWSEPPort();
	}

	public ClientVersionResponseDT getLatestVersion(int applicationId, OperatingSystem os){
		return configWS.getLatestVersion(applicationId, os);
	}

	private void handleRedirect(String redirectUrl, String cookies) throws DesktopLauncherException{
		throw new DesktopLauncherException(
				DesktopLauncherErrorCode.MAINTENANCE, 
				"Server Under Maintenance", 
				"The KodeFile Servers are currently undergoing scheduled Maintenance. "+
						"For more information, please visit www.1sqtechnologies.com\n"+
				"Thank you for your patience.");

	}
	
	private void handleServiceUnavailable() throws DesktopLauncherException{
		throw new DesktopLauncherException(
				DesktopLauncherErrorCode.NETWORK_ERROR, 
				"KodeFile Temporarily Unavailable", 
				"KodeFile servers are currently unavailable. Please try your request later."
				);		
	}
	
	private void handleGatewayTimeout() throws DesktopLauncherException{
		throw new DesktopLauncherException(
				DesktopLauncherErrorCode.GATEWAY_TIMEOUT, 
				"Connection Timeout", 
				"The server has not responded to your request. The server may be busy, please try again later.");
	}
	
	private void handleProxy() throws DesktopLauncherException{
		throw new DesktopLauncherException(
				DesktopLauncherErrorCode.PROXY_ERROR, 
				"Proxy Detected", 
				"A Proxy Server has been detected. Please check your proxy settings or contact your administrator."
				);
	}

	private boolean ensureServiceAvailability(URL url) throws DesktopLauncherException{
		HttpsURLConnection urlConnect ;
		int status;
		try {
			urlConnect = (HttpsURLConnection)url.openConnection();
			urlConnect.setInstanceFollowRedirects(false);

			urlConnect.setConnectTimeout(CONNECTION_TIMEOUT);
			urlConnect.connect();
			status = urlConnect.getResponseCode();
			switch(status){
			case HttpURLConnection.HTTP_ACCEPTED:

				break;
			case HttpURLConnection.HTTP_BAD_GATEWAY:

				break;
			case HttpURLConnection.HTTP_BAD_METHOD:

				break;
			case HttpURLConnection.HTTP_BAD_REQUEST:

				break;
			case HttpURLConnection.HTTP_CLIENT_TIMEOUT:

				break;
			case HttpURLConnection.HTTP_CONFLICT:

				break;
			case HttpURLConnection.HTTP_CREATED:

				break;
			case HttpURLConnection.HTTP_ENTITY_TOO_LARGE:

				break;
			case HttpURLConnection.HTTP_FORBIDDEN:

				break;
			case HttpURLConnection.HTTP_GATEWAY_TIMEOUT:
				handleGatewayTimeout();
				break;
			case HttpURLConnection.HTTP_GONE:

				break;
			case HttpURLConnection.HTTP_INTERNAL_ERROR:

				break;
			case HttpURLConnection.HTTP_LENGTH_REQUIRED:

				break;
			case HttpURLConnection.HTTP_MOVED_PERM:
			case HttpURLConnection.HTTP_MOVED_TEMP:
			case HttpURLConnection.HTTP_SEE_OTHER:
				handleRedirect(urlConnect.getHeaderField("Location"), urlConnect.getHeaderField("Set-Cookie"));
				break;
			case HttpURLConnection.HTTP_MULT_CHOICE:

				break;
			case HttpURLConnection.HTTP_NO_CONTENT:

				break;
			case HttpURLConnection.HTTP_NOT_ACCEPTABLE:

				break;
			case HttpURLConnection.HTTP_NOT_AUTHORITATIVE:

				break;
			case HttpURLConnection.HTTP_NOT_FOUND:

				break;
			case HttpURLConnection.HTTP_NOT_IMPLEMENTED:

				break;
			case HttpURLConnection.HTTP_NOT_MODIFIED:

				break;
			case HttpURLConnection.HTTP_OK:

				break;
			case HttpURLConnection.HTTP_PARTIAL:

				break;
			case HttpURLConnection.HTTP_PAYMENT_REQUIRED:

				break;
			case HttpURLConnection.HTTP_PRECON_FAILED:

				break;
			case HttpURLConnection.HTTP_PROXY_AUTH:

				break;
			case HttpURLConnection.HTTP_REQ_TOO_LONG:

				break;
			case HttpURLConnection.HTTP_RESET:

				break;
			case HttpURLConnection.HTTP_UNAUTHORIZED:

				break;
			case HttpURLConnection.HTTP_UNAVAILABLE:
				handleServiceUnavailable();
				break;
			case HttpURLConnection.HTTP_UNSUPPORTED_TYPE:

				break;
			case HttpURLConnection.HTTP_USE_PROXY:
				handleProxy();
				break;
			case HttpURLConnection.HTTP_VERSION:

				break;
			default:
				break;

			}

		}catch(UnknownHostException|SocketException e ){
			throw new DesktopLauncherException(
					DesktopLauncherErrorCode.NETWORK_ERROR, 
					"Internet Connection Failure", 
					"Unable to connect to server. Please check you internet connection and try again.");
		} catch (SocketTimeoutException e) {
			throw new DesktopLauncherException(
					DesktopLauncherErrorCode.NETWORK_ERROR, 
					"Connection Timeout", 
					"The server has not responded to your request. The server may be busy, please try again later.");
		}catch (IOException e) {
			e.printStackTrace();
			if(e.getMessage().contains("403 Forbidden") || e.getMessage().contains("Unable to tunnel through proxy")){
				throw new DesktopLauncherException(
						DesktopLauncherErrorCode.PROXY_ERROR, 
						"Connection Blocked by Proxy",
						"Unable to connect to the internet due to a proxy server that is refusing connections.\n"+
						"Please Check the proxy settings to make sure that they are correct.\n"+
						"You may also contact your network administrator to make sure the proxy server is working.");
								
			}else{
				throw new DesktopLauncherException(
						DesktopLauncherErrorCode.NETWORK_ERROR, 
						"Internet Connection Error",
						"Unable to connect to server due to the following error:\n\n"+
								e.getMessage());
			}
		}
		return true;
	}
}
