package kodename.kodeview.launcher.controller;

import java.io.IOException;
import java.net.URL;

import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import kodename.kodeview.launcher.viewer.FXMLUrls;


public class FXMLControllerLoader {

	
	public static Object loadController(String fxmlUrl) {
    	FXMLLoader fxmlLoader;
    	URL url;
    	url = FXMLUrls.class.getResource(fxmlUrl);
    	
    	if(url == null){
    		throw new RuntimeException("Unable To Locate FXML Resource @URL: "+ fxmlUrl);
    	}
    	try{
    		fxmlLoader = new FXMLLoader();
			fxmlLoader.setBuilderFactory(new JavaFXBuilderFactory());
			fxmlLoader.setLocation(url);		
			fxmlLoader.load(url.openStream());
    		return fxmlLoader.getController();			
    		
    	}
    	catch(IOException e){
    		e.printStackTrace();
    		return null;
    	}
	}

}
