package kodename.kodeview.launcher;

import java.util.Map;

import javafx.application.Application;
import javafx.application.HostServices;
import javafx.stage.Stage;
import kodename.kodeview.launcher.controller.FXMLControllerLoader;
import kodename.kodeview.launcher.controller.StartupController;
import kodename.kodeview.launcher.viewer.FXMLUrls;

public class Main extends Application {


	@Override
	public void start(final Stage initStage) throws Exception {
		String environment;
		Map<String, String> namedParams;

		Parameters params ;

		try{
			params = this.getParameters();
			namedParams = params.getNamed();
			environment = namedParams.get("environment");
			if(environment == null){
				environment = "prod";
			}
			startApplication(environment, initStage);
		}catch(Exception e){
			e.printStackTrace();
		}

	}
	
	
	public void startApplication(String environment, Stage stage) throws Exception {
		HostServices hostServices;
		StartupController controller;
		hostServices = getHostServices();


		try{
			controller = (StartupController)FXMLControllerLoader.loadController(FXMLUrls.STARTUP);
			controller.loadSplash(stage, environment, hostServices);
		}catch(Exception e){
			e.printStackTrace();
		}

	}

	public static void main(String args[]){
		launch(args); 
	}






}