package kodename.kodeview.launcher.utils;

import java.util.HashMap;
import java.util.Map;

import kodename.config.stubs.OperatingSystem;

public class OSUtils {
	
    public static String ARCH_PPC = "ppc";
    public static String ARCH_X86_32 = "x86_32";
    public static String ARCH_X86_64 = "x86_64";
    
	private static final String osName;
	private static final String osArch;
	private static final String osVersion;
	private static final Map<String, String> archMap;
	
	
	static{
		
		archMap = new HashMap<>();
		archMap.put("x86", ARCH_X86_32);
        archMap.put("i386", ARCH_X86_32);
        archMap.put("i486", ARCH_X86_32);
        archMap.put("i586", ARCH_X86_32);
        archMap.put("i686", ARCH_X86_32);
        archMap.put("x86_64", ARCH_X86_64);
        archMap.put("amd64", ARCH_X86_64);
        archMap.put("powerpc", ARCH_PPC);
        
        osName = System.getProperty("os.name").toLowerCase();// 	Operating system name
		osVersion = System.getProperty("os.version").toLowerCase();// 	Operating system version
        osArch = archMap.get(System.getProperty("os.arch").toLowerCase());// 	Operating system architecture
	}
	
	
	public static boolean isWindows32(){
		return isWindows() && is32Bit();
	}
	
	public static boolean isWindows64(){
		return isWindows() && is64Bit();
	}
	
	
	public static boolean isLinux32(){
		return isLinux() && is32Bit();
	}
	
	public static boolean isLinux64(){
		return isLinux() && is64Bit();
	}
	
	public static boolean isWindows(){
		return osName.contains("windows");
	}
	
	
	public static boolean isLinux(){
		return osName.contains("linux");
	}
	
	public static boolean isMac(){
		return osName.contains("mac");
	}
	
	
	public static boolean is32Bit(){
		return (osArch.compareToIgnoreCase(ARCH_X86_32)==0);
	}
	
	public static boolean is64Bit(){
		return (osArch.compareToIgnoreCase(ARCH_X86_64)==0);
	}
	
	public static String getOSName(){
		return osName;
	}
	public static String getOSVersion(){
		return osVersion;
	}
	
	public static String getOSArchitecture(){
		return osArch;
	}
	
	public static OperatingSystem getOS(){
		if(isWindows32()){
			return OperatingSystem.WINDOWS_32;
		}
		
		if(OSUtils.isWindows64()){
			return OperatingSystem.WINDOWS_64;
		}
		
		if(OSUtils.isLinux32()){
			return OperatingSystem.LINUX_32;
		}
		
		if(OSUtils.isLinux64()){
			return OperatingSystem.LINUX_64;
		}

		if(OSUtils.isMac()){
			return OperatingSystem.MACOSX;
		}
		
		return null;
	}
}
