/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.settings;

import java.util.concurrent.TimeUnit;

@Deprecated
final class StringParse {
    private static final String EVERY_CHUNK = "everyChunk";
    private static final long MINIMUM_PERIOD = 10000000L;

    private StringParse() {
    }

    public static boolean stackTrace(String string) {
        return StringParse.booleanValue("Stack trace", string);
    }

    public static boolean enable(String string) {
        return StringParse.booleanValue("Enable", string);
    }

    private static boolean booleanValue(String string, String string2) {
        String string3 = string2.trim().toLowerCase();
        if (string3.equals("true")) {
            return true;
        }
        if (string3.equals("false")) {
            return false;
        }
        throw new NumberFormatException("'" + string2 + "' is not a valid value. " + string + " must be true or false.");
    }

    public static long threshold(String string) {
        long l = StringParse.timespan(string.trim().toLowerCase());
        if (l >= 0L) {
            return l;
        }
        throw new NumberFormatException("'" + string + "' is not a valid value. Threshold can't be negative.");
    }

    public static long period(String string) {
        String string2 = string.trim().toLowerCase();
        if (string2.equalsIgnoreCase(EVERY_CHUNK)) {
            return 0L;
        }
        long l = StringParse.timespan(string2);
        if (l >= 10000000L) {
            return l;
        }
        throw new NumberFormatException("'" + string + "' is not a valid value. Period must have a unit and it must be at least 10 ms, i.e. '15 ms', or 'everyChunk'");
    }

    private static long timespan(String string) {
        if (string.endsWith("ns")) {
            return Long.parseLong(string.substring(0, string.length() - 2).trim());
        }
        if (string.endsWith("us")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(string.substring(0, string.length() - 2).trim()), TimeUnit.MICROSECONDS);
        }
        if (string.endsWith("ms")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(string.substring(0, string.length() - 2).trim()), TimeUnit.MILLISECONDS);
        }
        if (string.endsWith("s")) {
            return TimeUnit.NANOSECONDS.convert(Long.parseLong(string.substring(0, string.length() - 1).trim()), TimeUnit.SECONDS);
        }
        if (string.endsWith("m")) {
            return 60L * TimeUnit.NANOSECONDS.convert(Long.parseLong(string.substring(0, string.length() - 1).trim()), TimeUnit.SECONDS);
        }
        if (string.endsWith("h")) {
            return 3600L * TimeUnit.NANOSECONDS.convert(Long.parseLong(string.substring(0, string.length() - 1).trim()), TimeUnit.SECONDS);
        }
        if (string.endsWith("d")) {
            return 86400L * TimeUnit.NANOSECONDS.convert(Long.parseLong(string.substring(0, string.length() - 1).trim()), TimeUnit.SECONDS);
        }
        try {
            if (Long.parseLong(string) == 0L) {
                return 0L;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("'" + string + "' is not a valid timespan. Shoule be numeric value followed by a unit, i.e. 20 ms. Valid units are ns, us, s, m, h and d.");
        }
        throw new NumberFormatException("Timespan + '" + string + "' is missing unit. Valid units are ns, us, s, m, h and d.");
    }
}

