/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.CompletionHandlerWrapper;
import jdk.management.resource.internal.FutureWrapper;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="sun.nio.ch.UnixAsynchronousSocketChannelImpl")
public class UnixAsynchronousSocketChannelImplRMHooks {
    protected volatile InetSocketAddress localAddress = null;

    @InstrumentationMethod
    <A> Future<Void> implConnect(SocketAddress socketAddress, A a, CompletionHandler<Void, ? super A> completionHandler) {
        Future<Void> future;
        boolean bl;
        boolean bl2 = bl = this.localAddress != null;
        if (completionHandler != null && !bl) {
            completionHandler = new CompletionHandlerWrapper<Void, A>(completionHandler, this);
        }
        if ((future = this.implConnect(socketAddress, a, completionHandler)) != null && !bl) {
            if (future.isDone()) {
                ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.localAddress);
                ResourceRequest resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(this);
                long l = 0L;
                ResourceRequestDeniedException resourceRequestDeniedException = null;
                try {
                    l = resourceRequest.request(1L, resourceIdImpl);
                    if (l < 1L) {
                        resourceRequestDeniedException = new ResourceRequestDeniedException("Resource limited: too many open sockets");
                    }
                }
                catch (ResourceRequestDeniedException resourceRequestDeniedException2) {
                    resourceRequestDeniedException = resourceRequestDeniedException2;
                }
                if (resourceRequestDeniedException != null) {
                    resourceRequest.request(-l, resourceIdImpl);
                    CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
                    completableFuture.completeExceptionally(resourceRequestDeniedException);
                    future = completableFuture;
                    try {
                        this.implClose();
                    }
                    catch (IOException iOException) {}
                } else {
                    resourceRequest.request(-(l - 1L), resourceIdImpl);
                }
            } else {
                future = new FutureWrapper<Void>(future, this);
            }
        }
        return future;
    }

    @InstrumentationMethod
    <V extends Number, A> Future<V> implRead(boolean bl, ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, long l, TimeUnit timeUnit, A a, CompletionHandler<V, ? super A> completionHandler) {
        int n;
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.localAddress);
        ResourceRequest resourceRequest = ApproverGroup.SOCKET_READ_GROUP.getApprover(this);
        long l2 = 0L;
        if (bl) {
            n = 0;
            for (ByteBuffer byteBuffer2 : byteBufferArray) {
                n += byteBuffer2.remaining();
            }
        } else {
            n = byteBuffer.remaining();
        }
        try {
            l2 = Math.max(resourceRequest.request(n, resourceIdImpl), 0L);
            if (l2 < (long)n) {
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            if (completionHandler != null) {
                completionHandler.failed(resourceRequestDeniedException, a);
                return null;
            }
            CompletableFuture completableFuture = new CompletableFuture();
            completableFuture.completeExceptionally(resourceRequestDeniedException);
            return completableFuture;
        }
        if (completionHandler != null) {
            completionHandler = new CompletionHandlerWrapper<V, A>(completionHandler, resourceIdImpl, resourceRequest, l2);
        }
        Object object = this.implRead(bl, byteBuffer, byteBufferArray, l, timeUnit, a, completionHandler);
        if (completionHandler == null) {
            if (object.isDone()) {
                int n2 = 0;
                try {
                    n2 = ((Number)object.get()).intValue();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                n2 = Math.max(0, n2);
                resourceRequest.request(-(l2 - (long)n2), resourceIdImpl);
            } else {
                object = new FutureWrapper(object, resourceIdImpl, resourceRequest, l2);
            }
        }
        return object;
    }

    @InstrumentationMethod
    <V extends Number, A> Future<V> implWrite(boolean bl, ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, long l, TimeUnit timeUnit, A a, CompletionHandler<V, ? super A> completionHandler) {
        int n;
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.localAddress);
        ResourceRequest resourceRequest = ApproverGroup.SOCKET_WRITE_GROUP.getApprover(this);
        long l2 = 0L;
        if (bl) {
            n = 0;
            for (ByteBuffer byteBuffer2 : byteBufferArray) {
                n += byteBuffer2.remaining();
            }
        } else {
            n = byteBuffer.remaining();
        }
        try {
            l2 = Math.max(resourceRequest.request(n, resourceIdImpl), 0L);
            if (l2 < (long)n) {
                throw new ResourceRequestDeniedException("Resource limited: insufficient bytes approved");
            }
        }
        catch (ResourceRequestDeniedException resourceRequestDeniedException) {
            if (completionHandler != null) {
                completionHandler.failed(resourceRequestDeniedException, a);
                return null;
            }
            CompletableFuture completableFuture = new CompletableFuture();
            completableFuture.completeExceptionally(resourceRequestDeniedException);
            return completableFuture;
        }
        if (completionHandler != null) {
            completionHandler = new CompletionHandlerWrapper<V, A>(completionHandler, resourceIdImpl, resourceRequest, l2);
        }
        Object object = this.implWrite(bl, byteBuffer, byteBufferArray, l, timeUnit, a, completionHandler);
        if (completionHandler == null) {
            if (object.isDone()) {
                int n2 = 0;
                try {
                    n2 = ((Number)object.get()).intValue();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
                n2 = Math.max(0, n2);
                resourceRequest.request(-(l2 - (long)n2), resourceIdImpl);
            } else {
                object = new FutureWrapper(object, resourceIdImpl, resourceRequest, l2);
            }
        }
        return object;
    }

    @InstrumentationMethod
    void implClose() throws IOException {
        try {
            this.implClose();
        }
        finally {
            if (this.localAddress != null) {
                ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(this.localAddress);
                ResourceRequest resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(this);
                resourceRequest.request(-1L, resourceIdImpl);
            }
        }
    }
}

